#ifndef CRYS_HOST_OP_CODE_H
#define CRYS_HOST_OP_CODE_H
/*
   *  Object          : host_op_code.h
   *  State           :  %state%
   *  Creation date   :  Wed Nov 17 17:26:15 2004
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief this file containes the declerations of the HOST-SEP and vice versa op codes..
   *         
   *
   *  \version host_op_code.h#1:csrc:3
   *  \author avis
   *  \remarks Copyright (C) 2004 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************* Include Files ****************/
#include "host_op_code.h"


/************************ Defines ******************************/


/************************ Enums ******************************/

typedef enum
{

	DX_SEP_HOST_SEP_PROTOCL_HOST_AES_INIT_OP_CODE = DX_SEP_HOST_SEP_PROTOCOL_HOST_CRYS_FIRST_OP_CODE,
    DX_SEP_HOST_SEP_PROTOCL_HOST_AES_BLOCK_CODE = 0x3,
    DX_SEP_HOST_SEP_PROTOCL_HOST_AES_FINISH_OP_CODE = 0x4,
    DX_SEP_HOST_SEP_PROTOCL_HOST_AES_OP_CODE = 0x5,
    DX_SEP_HOST_SEP_PROTOCL_HOST_AES_WRAP_OP_CODE = 0x6,
    DX_SEP_HOST_SEP_PROTOCL_HOST_AES_UNWRAP_OP_CODE = 0x7,

	DX_SEP_HOST_SEP_PROTOCOL_HOST_DES_INIT_OP_CODE = 0x10,
	DX_SEP_HOST_SEP_PROTOCOL_HOST_DES_BLOCK_OP_CODE = 0x11,
	DX_SEP_HOST_SEP_PROTOCOL_HOST_DES_OP_CODE = 0x12,
	
	DX_SEP_HOST_SEP_PROTOCOL_HOST_HASH_INIT_OP_CODE = 0x20,
	DX_SEP_HOST_SEP_PROTOCOL_HOST_HASH_UPDATE_OP_CODE = 0x21,
	DX_SEP_HOST_SEP_PROTOCOL_HOST_HASH_FINISH_OP_CODE = 0x22,
	DX_SEP_HOST_SEP_PROTOCOL_HOST_HASH_OP_CODE = 0x23,

	DX_SEP_HOST_SEP_PROTOCOL_HOST_HMAC_INIT_OP_CODE = 0x30,
	DX_SEP_HOST_SEP_PROTOCOL_HOST_HMAC_UPDATE_OP_CODE = 0x31,
	DX_SEP_HOST_SEP_PROTOCOL_HOST_HMAC_FINISH_OP_CODE = 0x32,
	DX_SEP_HOST_SEP_PROTOCOL_HOST_HMAC_OP_CODE = 0x33,

	DX_SEP_HOST_SEP_PROTOCOL_HOST_RND_RESET_SEED_OP_CODE = 0x40,
	DX_SEP_HOST_SEP_PROTOCOL_HOST_RND_GENERAT_VECTOR_OP_CODE = 0x41,
	DX_SEP_HOST_SEP_PROTOCOL_HOST_RND_GENERAT_VECTOR_IN_RANGE_OP_CODE = 0x42,

	DX_SEP_HOST_SEP_PROTOCOL_HOST_CMLA_KDF_OP_CODE = 0x50,
	DX_SEP_HOST_SEP_PROTOCOL_HOST_CMLA_WRAP_OP_CODE = 0x51,
	DX_SEP_HOST_SEP_PROTOCOL_HOST_CMLA_UNWRAP_OP_CODE = 0x52,
	DX_SEP_HOST_SEP_PROTOCOL_HOST_CMLA_RSA_ENCRYPT_OP_CODE = 0x53,
	DX_SEP_HOST_SEP_PROTOCOL_HOST_CMLA_RSA_DECRYPT_OP_CODE = 0x54,

	DX_SEP_HOST_SEP_PROTOCOL_HOST_RC4_INIT_OP_CODE = 0x60,
	DX_SEP_HOST_SEP_PROTOCOL_HOST_RC4_STREAM_OP_CODE = 0x61,
	DX_SEP_HOST_SEP_PROTOCOL_HOST_RC4_OP_CODE = 0x62,

	DX_SEP_HOST_SEP_PROTOCOL_HOST_RSA_KG_OP_CODE = 0x70,

	DX_SEP_HOST_SEP_PROTOCOL_HOST_RSA_BUILD_PUB_KEY_OP_CODE = 0x71,
	DX_SEP_HOST_SEP_PROTOCOL_HOST_RSA_BUILD_PRIV_KEY_OP_CODE = 0x72,
	DX_SEP_HOST_SEP_PROTOCOL_HOST_RSA_BUILD_PRIV_KEY_CRT_OP_CODE = 0x78,
	DX_SEP_HOST_SEP_PROTOCOL_HOST_RSA_GET_PUB_KEY_OP_CODE = 0x73,
	DX_SEP_HOST_SEP_PROTOCOL_HOST_RSA_MOD_SIZE_OP_CODE = 0x74,
	DX_SEP_HOST_SEP_PROTOCOL_HOST_RSA_GET_PRIV_KEY_OP_CODE = 0x75,

	DX_SEP_HOST_SEP_PROTOCOL_HOST_RSA_PRIM_ENC_OP_CODE = 0x76,
	DX_SEP_HOST_SEP_PROTOCOL_HOST_RSA_PRIM_DEC_OP_CODE = 0x77,

	DX_SEP_HOST_SEP_PROTOCOL_HOST_RSA_ENC_OP_CODE = 0x7A,
	DX_SEP_HOST_SEP_PROTOCOL_HOST_RSA_DEC_OP_CODE = 0x7B,

	DX_SEP_HOST_SEP_PROTOCOL_HOST_RSA_SIGN_INIT_OP_CODE = 0x7C,
	DX_SEP_HOST_SEP_PROTOCOL_HOST_RSA_SIGN_UPDATE_OP_CODE = 0x7D,
	DX_SEP_HOST_SEP_PROTOCOL_HOST_RSA_SIGN_FINISH_OP_CODE = 0x7E,
	DX_SEP_HOST_SEP_PROTOCOL_HOST_RSA_SIGN_OP_CODE = 0x7F,

	DX_SEP_HOST_SEP_PROTOCOL_HOST_RSA_VERIFY_INIT_OP_CODE = 0x80,
	DX_SEP_HOST_SEP_PROTOCOL_HOST_RSA_VERIFY_UPDATE_OP_CODE = 0x81,
	DX_SEP_HOST_SEP_PROTOCOL_HOST_RSA_VERIFY_FINISH_OP_CODE = 0x82,
	DX_SEP_HOST_SEP_PROTOCOL_HOST_RSA_VERIFY_OP_CODE = 0x83,

	DX_SEP_HOST_SEP_PROTOCOL_HOST_RSA_GET_PRIV_KEY_MODULUS_OP_CODE = 0x84,

	DX_SEP_HOST_SEP_PROTOCOL_HOST_DH_GEN_PUB_PRV_OP_CODE = 0x90,
	DX_SEP_HOST_SEP_PROTOCOL_HOST_DH_GET_SEC_KEY_OP_CODE = 0x91,
	DX_SEP_HOST_SEP_PROTOCOL_HOST_DH_DER_KEY_OP_CODE = 0x92,

	DX_SEP_HOST_SEP_PROTOCOL_HOST_DH_X942_GET_SEC_DATA_OP_CODE = 0x93,
	DX_SEP_HOST_SEP_PROTOCOL_HOST_DH_X942_GET_HYBRID_SEC_DATA_OP_CODE = 0x94,

	DX_SEP_HOST_SEP_PROTOCOL_HOST_ECC_KG_OP_CODE = 0xA0,

	DX_SEP_HOST_SEP_PROTOCOL_HOST_ECC_BUILD_PUB_KEY_OP_CODE = 0xA1,
	DX_SEP_HOST_SEP_PROTOCOL_HOST_ECC_BUILD_PRIV_KEY_OP_CODE = 0xA2,
	DX_SEP_HOST_SEP_PROTOCOL_HOST_ECC_EXPORT_PUB_KEY_OP_CODE = 0xA3,

	DX_SEP_HOST_SEP_PROTOCOL_HOST_ECC_ELGAMAL_ENC_OP_CODE = 0xA4,
	DX_SEP_HOST_SEP_PROTOCOL_HOST_ECC_ELGAMAL_DEC_OP_CODE = 0xA5,

	DX_SEP_HOST_SEP_PROTOCOL_HOST_ECC_SIGN_INIT_OP_CODE = 0xA6,
	DX_SEP_HOST_SEP_PROTOCOL_HOST_ECC_SIGN_UPDATE_OP_CODE = 0xA7,
	DX_SEP_HOST_SEP_PROTOCOL_HOST_ECC_SIGN_FINISH_OP_CODE = 0xA8,
	DX_SEP_HOST_SEP_PROTOCOL_HOST_ECC_SIGN_OP_CODE = 0xA9,

	DX_SEP_HOST_SEP_PROTOCOL_HOST_ECC_VERIFY_INIT_OP_CODE = 0xAA,
	DX_SEP_HOST_SEP_PROTOCOL_HOST_ECC_VERIFY_UPDATE_OP_CODE = 0xAB,
	DX_SEP_HOST_SEP_PROTOCOL_HOST_ECC_VERIFY_FINISH_OP_CODE = 0xAC,
	DX_SEP_HOST_SEP_PROTOCOL_HOST_ECC_VERIFY_OP_CODE = 0xAD,

	DX_SEP_HOST_SEP_PROTOCOL_HOST_ECC_DH_OP_CODE = 0xAE,
	
	DX_SEP_HOST_SEP_PROTOCOL_HOST_GET_VERSION_OP_CODE = 0xB0,
	DX_SEP_HOST_SEP_PROTOCOL_HOST_SELF_TEST_OP_CODE = 0xB1,

	DX_SEP_HOST_SEP_PROTOCOL_HOST_C2_CIPHER_INIT_OP_CODE = 0xB3,
	DX_SEP_HOST_SEP_PROTOCOL_HOST_C2_CIPHER_BLOCK_OP_CODE = 0xB4,
	DX_SEP_HOST_SEP_PROTOCOL_HOST_C2_CIPHER_OP_CODE = 0xB5,
	DX_SEP_HOST_SEP_PROTOCOL_HOST_C2_CIPHER_HASH_INIT_OP_CODE = 0xB6,
	DX_SEP_HOST_SEP_PROTOCOL_HOST_C2_CIPHER_HASH_UPDATE_OP_CODE = 0xB7,
	DX_SEP_HOST_SEP_PROTOCOL_HOST_C2_CIPHER_HASH_FINISH_OP_CODE = 0xB8,
	DX_SEP_HOST_SEP_PROTOCOL_HOST_C2_CIPHER_HASH_OP_CODE = 0xB9,
	DX_SEP_HOST_SEP_PROTOCOL_HOST_C2_CIPHER_ONE_WAY_FUNC_OP_CODE = 0xBA,
	
	/* CRYS_SST Op Codes */
    DX_SEP_HOST_SEP_PROTOCOL_HOST_SST_AES_INIT_OP_CODE = 0xC0,
    DX_SEP_HOST_SEP_PROTOCOL_HOST_SST_AES_OP_CODE = 0xC1,
    DX_SEP_HOST_SEP_PROTOCOL_HOST_SST_DES_INIT_OP_CODE = 0xC2,
    DX_SEP_HOST_SEP_PROTOCOL_HOST_SST_DES_OP_CODE = 0xC3,
    DX_SEP_HOST_SEP_PROTOCOL_HOST_SST_HMAC_INIT_OP_CODE = 0xC4,
    DX_SEP_HOST_SEP_PROTOCOL_HOST_SST_HMAC_OP_CODE = 0xC5,
    DX_SEP_HOST_SEP_PROTOCOL_HOST_SST_RSA_ENC_OP_CODE = 0xC6,
    DX_SEP_HOST_SEP_PROTOCOL_HOST_SST_RSA_DEC_OP_CODE = 0xC7,
    DX_SEP_HOST_SEP_PROTOCOL_HOST_SST_RSA_SIGN_INIT_OP_CODE = 0xC8,
    DX_SEP_HOST_SEP_PROTOCOL_HOST_SST_RSA_SIGN_OP_CODE = 0xC9,
    DX_SEP_HOST_SEP_PROTOCOL_HOST_SST_RSA_VERIFY_INIT_OP_CODE = 0xCA,
    DX_SEP_HOST_SEP_PROTOCOL_HOST_SST_RSA_VERIFY_OP_CODE = 0xCB,
    DX_SEP_HOST_SEP_PROTOCOL_HOST_SST_RSA_PRIM_ENC_OP_CODE = 0xCC,
    DX_SEP_HOST_SEP_PROTOCOL_HOST_SST_RSA_PRIM_DEC_OP_CODE = 0xCD,

    /* CRYS_SST_KG Op Codes */
    DX_SEP_HOST_SEP_PROTOCOL_HOST_SST_KG_AES_OP_CODE = 0xD0,
    DX_SEP_HOST_SEP_PROTOCOL_HOST_SST_KG_DES_OP_CODE = 0xD1,
    DX_SEP_HOST_SEP_PROTOCOL_HOST_SST_KG_HMAC_OP_CODE = 0xD2,
    DX_SEP_HOST_SEP_PROTOCOL_HOST_SST_KG_RSA_OP_CODE = 0xD3,
    DX_SEP_HOST_SEP_PROTOCOL_HOST_SST_KG_RSA_CRT_OP_CODE = 0xD4,

    /* CRYS_KMNG Op Codes */
    DX_SEP_HOST_SEP_PROTOCOL_HOST_KMNG_AES_INIT_OP_CODE = 0xE1,
    DX_SEP_HOST_SEP_PROTOCOL_HOST_KMNG_AES_OP_CODE = 0xE2,
    DX_SEP_HOST_SEP_PROTOCOL_HOST_KMNG_DES_INIT_OP_CODE = 0xE3,
    DX_SEP_HOST_SEP_PROTOCOL_HOST_KMNG_DES_OP_CODE = 0xE4,
    DX_SEP_HOST_SEP_PROTOCOL_HOST_KMNG_HMAC_INIT_OP_CODE = 0xE5,
    DX_SEP_HOST_SEP_PROTOCOL_HOST_KMNG_HMAC_OP_CODE = 0xE6,
    DX_SEP_HOST_SEP_PROTOCOL_HOST_KMNG_RSA_ENC_OP_CODE = 0xE7,
    DX_SEP_HOST_SEP_PROTOCOL_HOST_KMNG_RSA_DEC_OP_CODE = 0xE8,
    DX_SEP_HOST_SEP_PROTOCOL_HOST_KMNG_RSA_SIGN_INIT_OP_CODE = 0xE9,
    DX_SEP_HOST_SEP_PROTOCOL_HOST_KMNG_RSA_SIGN_OP_CODE = 0xEA,
    DX_SEP_HOST_SEP_PROTOCOL_HOST_KMNG_RSA_VERIFY_INIT_OP_CODE = 0xEB,
    DX_SEP_HOST_SEP_PROTOCOL_HOST_KMNG_RSA_VERIFY_OP_CODE = 0xEC,
    DX_SEP_HOST_SEP_PROTOCOL_HOST_KMNG_RSA_PRIM_ENC_OP_CODE = 0xED,
    DX_SEP_HOST_SEP_PROTOCOL_HOST_KMNG_RSA_PRIM_DEC_OP_CODE = 0xEE,
    DX_SEP_HOST_SEP_PROTOCOL_HOST_KMNG_AES_WRAP_OP_CODE = 0xEF,
    DX_SEP_HOST_SEP_PROTOCOL_HOST_KMNG_AES_UNWRAP_OP_CODE = 0xF1,
    DX_SEP_HOST_SEP_PROTOCOL_HOST_KMNG_DH_PKCS3_GET_SECRET_KEY_OP_CODE = 0xF2,
    
    DX_SEP_HOST_SEP_PROTOCOL_HOST_KDF_KEY_DERIV_FUNC_OP_CODE = 0x101,
	
	/* OTF codes */
	DX_SEP_HOST_SEP_PROTOCOL_HOST_OTF_INIT_OPERATION_OP_CODE = 0x110,
	DX_SEP_HOST_SEP_PROTOCOL_HOST_OTF_SUSPEND_OPERATION_OP_CODE = 0x111,
	DX_SEP_HOST_SEP_PROTOCOL_HOST_OTF_RESUME_OPERATION_OP_CODE = 0x112,
	DX_SEP_HOST_SEP_PROTOCOL_HOST_OTF_END_OPERATION_OP_CODE = 0x113,

	/* AESCCM codes */
	DX_SEP_HOST_SEP_PROTOCL_HOST_AESCCM_INIT_OP_CODE = 0x120,
	DX_SEP_HOST_SEP_PROTOCL_HOST_AESCCM_BLOCK_ADATA_OP_CODE = 0x121,
	DX_SEP_HOST_SEP_PROTOCL_HOST_AESCCM_BLOCK_TDATA_OP_CODE = 0x122,
	DX_SEP_HOST_SEP_PROTOCL_HOST_AESCCM_BLOCK_LAST_TDATA_OP_CODE = 0x123,
	DX_SEP_HOST_SEP_PROTOCL_HOST_AESCCM_FINISH_OP_CODE = 0x124,
	DX_SEP_HOST_SEP_PROTOCL_HOST_AESCCM_OP_CODE = 0x125,

	DX_SEP_HOST_SEP_PROTOCOL_CRYS_MAX_CODE = DX_SEP_HOST_SEP_PROTOCOL_HOST_CRYS_LAST_OP_CODE 
    
}DX_SEP_HOST_SEP_CRYS_OP_CODE_type;


/************************ Typedefs ******************************/


/************************ Global Data ******************************/


/************* Private function prototypes ****************/


#endif

